#!/bin/bash
#
# Copyright © 2025 Dr. Helge Kreutzmann <debian@helgefjell.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This script moves files without upstream man pages in the archive
# This happens, if translations move to upstream and the last distribution
# which shipped them in manpages-l10n is no longer present

if [ -d man1 ]; then
    lcode=$(basename $(pwd))
elif [ a"$1" != a ]; then
    if [ -d $1 ]; then
        cd $1
        lcode=$1
    else
        echo "Language $1 could not be found, aborting"
        exit 11
    fi
else
    echo "Could not determine target directory, aborting"
    exit 12
fi

source ../l10n_set

for f in $(../no-upstream.sh| awk '{print $5}'); do
    verz=$(dirname $f)
    name=$(basename $f)
    # Check, if the archive directory already exists 
    if [ ! -d archive/$verz ]; then
	echo Directory $verz does not exist in archive
	mkdir archive/$verz
    fi
    # Check, if the file already exists 
    if [ -e archive/$verz/$name ]; then
	echo "archive/$verz/$name already exists"
    else
    	git mv $verz/$name archive/$verz/$name
    fi
done
